"use strict";const showHelp=()=>{process.stdout.write("\nUsage: \n  node sensor.js userscript.js [arguments]\n\nEnvironment variables:\n  SENSOR_BRIDGE   bridge endpoint\n")};(process.argv.length<3||process.argv.includes("--help"))&&(process.stdout.write("\nUsage: \n  node sensor.js userscript.js [arguments]\n\nEnvironment variables:\n  SENSOR_BRIDGE   bridge endpoint\n"),process.exit(1));const fs=require("fs"),path=require("path"),Log=require("./classes/Logger").logger("main");Log.on("message",Log.output.stdout.full);const packageJSONPath=path.join(__dirname,"..","package.json");let SensorBridge=process.env.SENSOR_BRIDGE||process.env.SENSOR_AGENT||"",SensorVersion="";try{if(!SensorBridge){const e=JSON.parse(fs.readFileSync(packageJSONPath).toString());e.sensoragent&&e.sensoragent.startsWith("http")&&(SensorBridge=e.sensoragent.trim()),SensorVersion="node-"+parseInt(e.version)}}catch(e){}const si=require("./classes/ScriptInspector"),bridge=require("./classes/BridgeConnection").connect(SensorBridge,{options:{version:SensorVersion}});bridge.on("notifyfail",(e=>{bridge.pauseNotifications()&&Log.info(`Bridge notifications paused. (Reason: ${JSON.stringify(e)})`)}));const handleDiscovery=e=>{e.location||(e.location={path:"/",line:0,stack:""}),bridge.notify(e),process.env.DumpSensorIO?process.stderr.write(JSON.stringify(e)+"\n"):Log.debug(e.event,e.data)};si.create({nodeExecutable:process.argv[0],scriptPath:process.argv[2],scriptArgs:Array.from(process.argv).splice(3)}).then((e=>{e.on("discovery",(({type:e,data:s,location:r,additional:n})=>{handleDiscovery({event:e,location:r,data:s,additional:n})})),e.on("scanid",(e=>{bridge.setScanId(e)})),e.on("sensorpassword",(e=>{SensorBridge.endsWith(e)||(Log.warn("Sensor token mismatch"),bridge.resetScanId())})),e.on("sensorrequest",(()=>{bridge.resumeNotifications()&&Log.info("Bridge notifications resumed.")})),e.on("sensorquery",(s=>{switch(s){case"filelist":const s=e.getDiscoveredPaths();handleDiscovery({event:"File_List",data:s});break;case"packages":const r=[],n=Array.from(e.getDiscoveredModules()),o=Array.from(e.getDeclaredModules());n.forEach((e=>{r.push(e)})),o.forEach((e=>{if(r.includes(e))return!1;r.push(e)})),handleDiscovery({event:"Packages",data:r,additional:["npm"]});break;case"aspectalerts":handleDiscovery({event:"Aspect_Alerts",data:e.getDiscoveredConfig()});break;case"routes":Object.entries(e.getGroupedRoutes()).forEach((([e,s])=>{handleDiscovery({event:"Routes",data:s,additional:[e]})}))}})),e.on("moduleloaded",(({name:e,version:s},r)=>{Log.debug(`Loaded dependency ${e}@${s}`)}))}));