"use strict";function asyncGeneratorStep(e,t,s,r,i,o,n){try{var a=e[o](n),c=a.value}catch(e){return void s(e)}a.done?t(c):Promise.resolve(c).then(r,i)}function _asyncToGenerator(e){return function(){var t=this,s=arguments;return new Promise((function(r,i){var o=e.apply(t,s);function n(e){asyncGeneratorStep(o,r,i,n,a,"next",e)}function a(e){asyncGeneratorStep(o,r,i,n,a,"throw",e)}n(void 0)}))}}const EventEmitter=require("events"),Log=require("./Logger").logger("inspector");Log.on("message",Log.output.stdout.full);const _require=require("child_process"),spawn=_require.spawn,fs=require("fs"),path=require("path"),HeaderSensorEnabled="acunetix-aspect",HeaderSensorQueries="acunetix-aspect-queries",HeaderSensorPassword="acunetix-aspect-password",HeaderScanID="acunetix-aspect-scanid",HooksFileName="hooks.js",DiscoveryType=Object.freeze({File_Open:"File_Open",File_Write:"File_Write",File_Move:"File_Move",File_Copy:"File_Copy",File_Delete:"Delete_File",SQL_Query:"SQL_Query",Send_Mail:"Send_Mail",Sys_Command:"Sys_Command",Url_Open:"Url_Open",Template_Render:"Template_Render",XML_Parse:"XML_Parse",MongoDB_Query:"MongoDB_Query",LDAP_Query:"LDAP_Query"}),log=Object.freeze({info:(...e)=>{Log.info(...e)},warn:(...e)=>{Log.warn(...e)},debug:(...e)=>{Log.debug(...e)},error:(...e)=>{Log.error(...e)}}),getDirItems=e=>{let t=[];try{t=fs.readdirSync(e)}catch(e){}return t},safeFileExists=e=>{let t=!1;try{t=fs.existsSync(e)}catch(e){}return t};class ScriptInspector extends EventEmitter{constructor({nodeExecutable:e,scriptPath:t,scriptArgs:s=[],customHooks:r=[]}){super(),this._nodeExecutable=e,this._scriptPath=t,this._scriptArgs=s,this._checkedModulePaths=new Set,this._discoveredRoutes=new Set,this._discoveredModules=new Set,this._declaredModules=new Set,this._applicationConfig={},"development"===process.env.NODE_ENV&&(this._applicationConfig.express_dev_mode=!0),process.nextTick((()=>{log.info("Launching Node Process.."),this._launch((()=>{log.info("Process launched."),this.emit("ready")}))}))}_emitDiscovery(e,t,s,r){const i=[];r&&i.push(r),s.stack&&i.push(s.stack),this.emit("discovery",{type:e,data:t,location:s,additional:i})}_isValidRoute(e){return e.startsWith("/")}_handleLDAPDiscovery(e,t){this._emitDiscovery(DiscoveryType.LDAP_Query,e.filter,t)}_handleNoSQLDiscovery(e,t){if("mongodb"!==e.engine)return!1;let s;try{s=JSON.stringify(e.query)}catch(e){return!1}this._emitDiscovery(DiscoveryType.MongoDB_Query,s,t,`databasename=${e.database}; collection=${e.collection}; method=${e.method}`)}_handleSQLDiscovery(e,t){this._emitDiscovery(DiscoveryType.SQL_Query,e.sql,t,"database="+e.engine)}_handleTemplateMarkup({markup:e},t){this._emitDiscovery(DiscoveryType.Template_Render,e,t)}_handleXMLParser({markup:e},t){this._emitDiscovery(DiscoveryType.XML_Parse,e,t)}_handleConfigurationDiscovery(e,t){Object.assign(this._applicationConfig,e)}_handleRouteDiscovery(e,t){const s=e.route;if(!this._isValidRoute(s))return!1;this.emit("route",s,t),this._discoveredRoutes.add(e)}_handleIncomingHTTPRequest(e,t){if("incoming"!==e.direction)return!1;const s=e.request,r=s.url,i=s.method,o=s.headers;this.emit("httprequest",`${i} ${r}`,t);let n=!1;const a=[];"object"==typeof o&&(o["acunetix-aspect"]&&(n=!0),"string"==typeof o[HeaderScanID]&&(n=!0,this.emit("scanid",o[HeaderScanID])),"string"==typeof o[HeaderSensorPassword]&&(n=!0,this.emit("sensorpassword",o[HeaderSensorPassword])),"string"==typeof o[HeaderSensorQueries]&&(n=!0,o[HeaderSensorQueries].length<500?o[HeaderSensorQueries].split(";").forEach((e=>{a.push(e.trim())})):log.warn(`${HeaderSensorQueries} header ignored as it exceeds max size (${o[HeaderSensorQueries].length} bytes)`))),n&&this.emit("sensorrequest"),a.forEach((e=>{this.emit("sensorquery",e)}))}_handleOutgoingHTTPRequest(e,t){if("outgoing"!==e.direction)return!1;this._emitDiscovery(DiscoveryType.Url_Open,e.request.url,t)}_handleHTTPRequest(e,t){return!!e.request&&("incoming"===e.direction?this._handleIncomingHTTPRequest(e,t):this._handleOutgoingHTTPRequest(e,t))}_handleMailDiscovery(e,t){const s=[e.to,e.subject];this._emitDiscovery(DiscoveryType.Send_Mail,s,t)}_handleSysCommandDiscovery(e,t){const s=e.args;this._emitDiscovery(DiscoveryType.Sys_Command,s[0],t)}_handleFSDiscovery(e,t){const s=e.args;if(t&&t.path&&(t.path.startsWith("internal/")||"fs.js"===t.path))return!1;switch(e.method){case"unlink":case"unlinkSync":this._emitDiscovery(DiscoveryType.File_Delete,s[0],t);break;case"open":case"openSync":case"readFile":case"readFileSync":case"createReadStream":this._emitDiscovery(DiscoveryType.File_Open,s[0],t);break;case"writeFile":case"writeFileSync":case"appendFile":case"appendFileSync":case"createWriteStream":this._emitDiscovery(DiscoveryType.File_Write,s[0],t);break;case"rename":case"renameSync":this._emitDiscovery(DiscoveryType.File_Move,`${s[0]} - ${s[1]}`,t);break;case"copyFile":case"copyFileSync":this._emitDiscovery(DiscoveryType.File_Copy,`${s[0]} - ${s[1]}`,t)}}_findDeclaredModules(e){const t=require("module").Module;if(!t||"function"!=typeof t._nodeModulePaths)return;const s=t._nodeModulePaths(path.dirname(e));if(!(s instanceof Array))return;let r=null;for(let e=0;e<s.length;e++){const t=s[e].split(path.sep);t.pop();const i=t.join(path.sep)+path.sep+"package-lock.json";if(safeFileExists(i)){log.info("Found package-lock.json at",i),r=i;break}}let i=null;for(let e=0;e<s.length;e++){const t=s[e];try{if(fs.existsSync(t)){i=t,log.info("Found node_modules folder",i);break}}catch(e){}}let o=new Set;if(r&&(o=this._extractModulesFromPackageLock(r)),i){const e=[];e.push(i);let t=0;for(;0!==e.length;){if(t++,t>1e4){log.error("node_modules recursive walk limit exhausted");break}const s=e.shift(),r=getDirItems(s);for(let t=0;t<r.length;t++){const i=path.join(s,r[t]),n=path.join(i,"package.json"),a=path.join(i,"node_modules");if(safeFileExists(n))try{const e=require(n),t=e.name,s=e.version;t&&s&&o.add(`${t}@${s}`)}catch(e){}safeFileExists(a)&&e.push(a)}}}this._declaredModules=o}_extractModulesFromPackageJSON(e){const t={};let s=null;try{s=JSON.parse(fs.readFileSync(e))}catch(e){}if(s&&"object"==typeof s.dependencies)for(let e in s.dependencies){let r=s.dependencies[e];if("string"!=typeof r)continue;const i=r.charAt(0);parseInt(i,10)+""===i||(r=r.substr(1)),t[e]=r}return t}_extractModulesFromPackageLock(e){const t=new Set;let s=null;try{s=JSON.parse(fs.readFileSync(e))}catch(e){}const r=[];s&&"object"==typeof s.dependencies&&r.push(s.dependencies);let i=0;for(;0!==r.length;){if(i++,i>1e4){log.error("dependency recursive walk limit exhausted");break}const e=r.shift();for(let s in e){const i=e[s];i.dependencies&&r.push(i.dependencies),"object"==typeof i&&"string"==typeof i.version&&t.add(`${s}@${i.version}`)}}return t}_checkIfModuleLoader(e,t=""){if(!e)return!1;if(this._checkedModulePaths.has(e))return!1;this._checkedModulePaths.add(e);let s={path:"",line:0};const r=t.split("\n");for(let e=2;e<r.length;e++){const t=r[e].trim(),i=this._extractLocationFromStackLine(t);if(!i||!i.path||!i.path.startsWith("internal/")&&!i.path.includes("hooks.js")){s=i;break}}let i=path.dirname(e);if(!i.includes(path.sep+"node_modules"))return!1;this._findPackageJSON(i,(e=>{e&&this._emitModuleLoaded(e,s)}))}_findPackageJSON(e,t=(()=>{})){const s=path.join(e,"package.json");fs.stat(s,((r,i)=>{if(!r&&i.isFile())return t(s);const o=e.split(path.sep);o.pop();if("node_modules"===o[o.length-1])return t(null);this._findPackageJSON(o.join(path.sep),t)}))}_emitModuleLoaded(e,t){const s=require(e),r=s.name,i=s.version;if(!r||!i)return!1;const o=`${r}@${i}`;if(this._discoveredModules.has(o))return!1;this._discoveredModules.add(o),this.emit("moduleloaded",{name:r,version:i},t)}_extractLocationFromStackLine(e){let t=e.indexOf(" ("),s=null;-1!==t?(t+=2,s=e.substring(t,e.length-1)):s=e.trim().substring(3);const r=s.lastIndexOf(":"),i=s.lastIndexOf(":",r-1),o=parseInt(s.substr(i+1),10);let n=s.substr(0,i);return n.startsWith("file:///")&&(n=n.substr(8)),{path:path.join(n),line:o}}_extractLineFromStack(e,t){const s=e.split("\n")[t];return s?this._extractLocationFromStackLine(s):{}}_processMessage(e){const t=e.hook,s=e.data,r=e.stack,i=e.firstUserLineIndex;if(!t||!s)return!1;let o={};switch(r&&(o=this._extractLineFromStack(r,i)),e.userStack&&(isNaN(o.line)&&(o=this._extractLocationFromStackLine(e.userStack[0])),o.stack=e.userStack.join("\n")),t){case"core.require":this._checkIfModuleLoader(s.path,r);break;case"core.fs":"openSync"===s.method&&this._checkIfModuleLoader(s.args[0]),this._handleFSDiscovery(s,o);break;case"core.child_process":this._handleSysCommandDiscovery(s,o);break;case"sendmail":this._handleMailDiscovery(s,o);break;case"route":this._handleRouteDiscovery(s,o);break;case"sql":this._handleSQLDiscovery(s,o);break;case"httprequest":this._handleHTTPRequest(s,o);break;case"configuration":this._handleConfigurationDiscovery(s,o);break;case"template":this._handleTemplateMarkup(s,o);break;case"xmlparser":this._handleXMLParser(s,o);break;case"nosql":this._handleNoSQLDiscovery(s,o);break;case"ldapquery":this._handleLDAPDiscovery(s,o)}}_launch(e){log.info("Node Executable",this._nodeExecutable);const t=path.join(__dirname,"..","hooks.js");let s=process.cwd();s=path.resolve(s);const r={};Object.assign(r,process.env);const i=s.split(path.sep);for(;0!==i.length;){const e=path.join(i.join(path.sep),"node_modules");try{if(fs.statSync(e).isDirectory()){r.NODE_PATH=e,log.info("NODE_PATH set to "+e);break}}catch(e){}i.pop()}const o=spawn(this._nodeExecutable,["--require",t,this._scriptPath,...this._scriptArgs],{stdio:["pipe","pipe","pipe","ipc"],env:r});o.on("message",(e=>{if("object"!=typeof e)return!1;this._processMessage(e)})),o.stdout.on("data",(e=>{process.stdout.write(e)})),o.stderr.on("data",(e=>{process.stderr.write(e)})),e(),this._findDeclaredModules(this._scriptPath)}getDiscoveredPaths(){const e=new Set;return this.getDiscoveredRoutes().forEach((({route:t})=>{e.add(t)})),Array.from(e)}getDiscoveredRoutes(){return Array.from(this._discoveredRoutes)}getGroupedRoutes(){const e={};return this.getDiscoveredRoutes().forEach((({route:t,method:s,framework:r})=>{e[r]=e[r]||[];const i=`${s} ${t}`;e[r].includes(i)||e[r].push(i)})),e}getDiscoveredModules(){return this._discoveredModules}getDeclaredModules(){return this._declaredModules}getDiscoveredConfig(){const e=[],t=this._applicationConfig,s=t.has_node_exception_handler,r=t.has_node_rejection_handler,i=t.express_session_secret,o=t.express_dev_mode;return s||e.push("missing_node_exception_handler=true"),r||e.push("missing_node_rejection_handler=true"),"string"==typeof i&&e.push("express_session_secret="+i),o&&e.push("express_dev_mode=true"),e}}exports.create=function(){var e=_asyncToGenerator((function*(...e){log.debug("creating inspector instance");const t=new ScriptInspector(...e);return new Promise((e=>{t.on("ready",_asyncToGenerator((function*(){log.debug("inspector ready"),e(t)})))}))}));return function(){return e.apply(this,arguments)}}();