"use strict";const https=require("https"),EventEmitter=require("events"),crypto=require("crypto"),Log=require("./Logger").logger("bridge");Log.on("message",Log.output.stdout.full);const _URL=require("url"),requestAgent=new https.Agent({keepAlive:!1,timeout:1e4,maxSockets:3,maxCachedSessions:0}),ResumeDelayMS=1e4;class BridgeConnection extends EventEmitter{constructor(t,{options:e}){super(),Log.info("endpoint set to "+t),this._endpoint=t,this._options=e||{},this._scanId=null,this._allowNotifications=!1,this._lastPausedTime=null,this._queuedDiscoveries=[],this._lastSecondHashes={}}notify(t){return!(!this._endpoint||!this._allowNotifications)&&(!this._sameNotificationJustSent(t)&&void this._sendDiscovery(t))}pauseNotifications(){return!!this._allowNotifications&&(this._lastPausedTime=(new Date).getTime(),this._allowNotifications=!1,!0)}resumeNotifications({force:t}={}){if(this._allowNotifications)return!1;if(t)return this._allowNotifications=!0,!0;const e=this._lastPausedTime;if(null===e)return this._allowNotifications=!0,!0;return(new Date).getTime()-e>1e4&&(this._allowNotifications=!0,!0)}_sameNotificationJustSent(t){const e=crypto.createHash("md5").update(JSON.stringify(t)).digest("hex"),i=Math.floor((new Date).getTime()/1e3);if(this._lastSecondHashes[i]){if(this._lastSecondHashes[i].has(e))return!0}else this._lastSecondHashes={};return this._lastSecondHashes[i]=this._lastSecondHashes[i]||new Set,this._lastSecondHashes[i].add(e),!1}get scanId(){return this._scanId}setScanId(t){this._scanId=t}resetScanId(){this._scanId=null}_convertDiscoveryToSensorFormat(t){const e=t.additional instanceof Array?t.additional:[];return{key:t.event,msg:t.data,file:t.location?t.location.path:"/",line:t.location?t.location.line:"0",additional:e}}_sendDiscovery(t){if(this.isWriting)return void this._queuedDiscoveries.push(t);const e=[];this._queuedDiscoveries.forEach((t=>{e.push(this._convertDiscoveryToSensorFormat(t))})),this._queuedDiscoveries.length=0,e.push(this._convertDiscoveryToSensorFormat(t));let i=this._endpoint;if("string"==typeof this._options.version){const t=this._options.version;i+="?version="+t,e.push({key:"sv",msg:[t]})}null!==this.scanId&&e.push({key:"scan-id",msg:[this.scanId]});const s=BridgeConnection.serializeEntries(e);let n=null;try{n=_URL.parse(i)}catch(t){Log.warn("Invalid agent URL",t.message)}if(!n)return!1;const o={method:"POST",hostname:n.hostname,path:n.path,port:n.port,rejectUnauthorized:!1,agent:requestAgent},r=https.request(o,(t=>{200!==t.statusCode&&this._emitBridgeFailure({type:"badstatus",status:t.statusCode})}));Log.debug(`Sending ${e.length-2} item(s) to bridge [size: ${s.length}]`),this._setWriting(!0),r.on("socket",(t=>{t.on("close",(()=>{this._setWriting(!1)})),t.on("error",(t=>{Log.debug("socket error",t)}))})),r.on("error",(t=>{this._setWriting(!1),this._emitBridgeFailure({type:"connectfail",error:t.code})})),r.write(s,(()=>{Log.debug(`Data sent to bridge [size: ${s.length}]`)})),r.end()}get isWriting(){return this._writing}_setWriting(t){this._writing=t,this.isWriting||this._processWriteQueue()}_processWriteQueue(){return!this.isWriting&&(0!==this._queuedDiscoveries.length&&void this._sendDiscovery(this._queuedDiscoveries.shift()))}_emitBridgeFailure(t){this.emit("notifyfail",t)}static serializeEntries(t){const e=t=>("00000000"+t.toString(16)).substr(-8),i=t=>{let i=0;try{i=(new TextEncoder).encode(t).length}catch(e){i=t.length}return`${e(i)}${t}`},s=t=>i(t?t.toString():""),n=t=>Array.isArray(t)?`a${e(t.length)}${t.map(s).join("")}`:t?"s"+s(t):"n",o=(t,o,r,a,c)=>{return`${i(t)}${n(o)}${s(r)}${h=a,e(h||0)}${n(c)}`;var h};return r=t.reduce(((t,e)=>t+o(e.key,e.msg,e.file,e.line,e.additional)),""),Buffer.from(r).toString("base64");var r}}exports.connect=(...t)=>new BridgeConnection(...t);