﻿String.prototype.replaceAll = function (search, replacement) {
    try {
        var target = this;
        return target.split(search).join(replacement);
    } catch (e) {
        return this;
    }
};

function executeBotDetection(){
    console.log("Bot Detection Configuration Enabled");

    // remove navigator.webdriver property
    // NOTE: disabled overiding of navigator.webdriver due to https://bugs.chromium.org/p/chromium/issues/detail?id=1152355
    Object.defineProperty(navigator, 'webdriver', {
        get: () => undefined,
        configurable: true  // Make it redefinable
    });

    // hardcode connection.rtt (it is set to 0 with headless)
    try {
        Object.defineProperty(navigator.connection, 'rtt', {get: () => 150});
    }
    catch(e) {};

    // override plugins

    function fakePluginArray() {
        return new Proxy(this, {
            get: (target, propName) => {
                if(propName === 'length') {
                    return 2;
                }
                else if(propName === 'refresh') {
                    return ()=>{};
                }
                else if((parseInt(propName, 10) + '') === propName + '') {
                    if(propName === 2 || propName === '2') {
                        // avoid infinite looping
                        //
                        // the following implementation was looping forever
                        /*
                          for (var o = [], i = navigator.plugins, s = 0; i[s]; ++s) {
                          }
                        */
                        return undefined;
                    }
                    return new fakePlugin();
                }
                else {
                    return target[propName];
                }
            }
        });
    };

    function fakePlugin() {
        this.name = 'Mock Name';
        this.description = 'Mock Description';
        this.length = 0;
        this.filename = 'mockfile.ext'
    };

    try {
        Object.defineProperty(window, 'PluginArray', {get: () => { return fakePluginArray; }});
        Object.defineProperty(window, 'Plugin', {get: () => { return fakePlugin; }});
        Object.defineProperty(navigator, 'plugins', {get: () => { return new fakePluginArray() }});
    }
    catch(e) {};

    // override mimetype array
    function fakeMimeArray() {
        return new Proxy(this, {
            get: (target, propName) => {
                if(propName === 'length') {
                    return 2;
                }
                else if(propName === 'namedItem') {
                    return () => { return null; };
                }
                else if((parseInt(propName, 10) + '') === propName + '') {
                    if(propName === 2 || propName === '2') {
                        // avoid infinite looping
                        return undefined;
                    }
                    return new fakeMime();
                }
                else {
                    return target[propName];
                }
            }
        });
    };

    function fakeMime() {
        this.description = 'Mock Mimetype';
        this.suffixes = 'mock';
        this.type = 'mock/mime';
    };
    try {
        Object.defineProperty(window, 'MimeTypeArray', {get: () => { return fakeMimeArray; }});
        Object.defineProperty(window, 'MimeType', {get: () => { return fakeMime; }});
        Object.defineProperty(navigator, 'mimeTypes', {get: () => { return new fakeMimeArray() }});
    }
    catch(e) {};
}

function getSelector(el, optimized) {
    return chromiumCssPath(el, optimized);
}

var chromiumCssPath = (function () {
    var DOMNodePathStep = function (value, optimized) {
        this.value = value;
        this.optimized = optimized || false;
    };

    DOMNodePathStep.prototype = {
        toString: function () {
            return this.value;
        }
    };

    var isCSSIdentChar = function (c) {
        if (/[a-zA-Z0-9_-]/.test(c))
            return true;
        return c.charCodeAt(0) >= 0xA0;
    }

    var isCSSIdentifier = function (value) {
        return /^-?[a-zA-Z_][a-zA-Z0-9_-]*$/.test(value);
    }

    var toHexByte = function (c) {
        var hexByte = c.charCodeAt(0).toString(16);
        if (hexByte.length === 1)
            hexByte = "0" + hexByte;
        return hexByte;
    }

    var escapeAsciiChar = function (c, isLast) {
        return "\\\\" + toHexByte(c) + (isLast ? "" : " ");
    }

    var escapeIdentifierIfNeeded = function (ident) {
        if (isCSSIdentifier(ident))
            return ident;
        var shouldEscapeFirst = /^(?:[0-9]|-[0-9-]?)/.test(ident);
        var lastIndex = ident.length - 1;
        return ident.replace(/./g,
            function (c, i) {
                return ((shouldEscapeFirst && i === 0) || !isCSSIdentChar(c)) ? escapeAsciiChar(c, i === lastIndex) : c;
            });
    }

    var nodeNameInCorrectCase = function (node) {
        var shadowRootType = node._shadowRootType || null;
        if (shadowRootType)
            return '#shadow-root (' + shadowRootType + ')';

        // If there is no local name, it's case sensitive
        if (!node.localName)
            return node.nodeName;

        // If the names are different lengths, there is a prefix and it's case sensitive
        if (node.localName.length !== node.nodeName.length)
            return node.nodeName;

        // Return the localname, which will be case insensitive if its an html node
        return node.localName;
    }

    var idSelector = function (id) {
        return "#" + escapeIdentifierIfNeeded(id);
    }

    var keySet = function (arr) {
        var keys = {};
        for (var i = 0; i < arr.length; ++i) {
            keys[arr[i]] = true;
        }
        return keys;
    };

    var cssPathStep = function (node, optimized, isTargetNode, useId) {
        if (node.nodeType !== 1)
            return null;

        var id = node.getAttribute("id");
        if (optimized) {
            if (id && useId)
                return new DOMNodePathStep(idSelector(id), true);
            var nodeNameLower = node.nodeName.toLowerCase();
            if (nodeNameLower === "body" || nodeNameLower === "head" || nodeNameLower === "html")
                return new DOMNodePathStep(nodeNameInCorrectCase(node), true);
        }

        var nodeName = nodeNameInCorrectCase(node);

        if (id && useId)
            return new DOMNodePathStep(nodeName + idSelector(id), true);
        var parent = node.parentNode;
        if (!parent || parent.nodeType === 9)
            return new DOMNodePathStep(nodeName, true);

        function prefixedElementClassNames(node) {
            var classAttribute = node.getAttribute("class");
            if (!classAttribute)
                return [];

            return classAttribute.split(/\s+/g).filter(Boolean).map(function (name) {
                // The prefix is required to store "__proto__" in a object-based map.
                return "$" + name;
            });
        }

        var prefixedOwnClassNamesArray = prefixedElementClassNames(node);
        var needsClassNames = false;
        var needsNthChild = false;
        var ownIndex = -1;
        var elementIndex = -1;
        var siblings = parent.children;
        for (var i = 0; (ownIndex === -1 || !needsNthChild) && i < siblings.length; ++i) {
            var sibling = siblings[i];
            if (sibling.nodeType !== 1)
                continue;
            elementIndex += 1;
            if (sibling === node) {
                ownIndex = elementIndex;
                continue;
            }
            if (needsNthChild)
                continue;
            if (nodeNameInCorrectCase(sibling) !== nodeName)
                continue;

            needsClassNames = true;
            var ownClassNames = keySet(prefixedOwnClassNamesArray);
            var ownClassNameCount = 0;
            for (var name in ownClassNames) {
                if (ownClassNames.hasOwnProperty(name)) {
                    ++ownClassNameCount;
                }
            }
            if (ownClassNameCount === 0) {
                needsNthChild = true;
                continue;
            }
            var siblingClassNamesArray = prefixedElementClassNames(sibling);
            for (var j = 0; j < siblingClassNamesArray.length; ++j) {
                var siblingClass = siblingClassNamesArray[j];
                if (!ownClassNames.hasOwnProperty(siblingClass))
                    continue;
                delete ownClassNames[siblingClass];
                if (!--ownClassNameCount) {
                    needsNthChild = true;
                    break;
                }
            }
        }

        var result = nodeName;
        if (isTargetNode &&
            nodeName.toLowerCase() === "input" &&
            node.getAttribute("type") &&
            !node.getAttribute("id") &&
            !node.getAttribute("class"))
            result += "[type=\"" + node.getAttribute("type") + "\"]";
        if (needsNthChild) {
            result += ":nth-child(" + (ownIndex + 1) + ")";
        } else if (needsClassNames) {
            var ks = keySet(prefixedOwnClassNamesArray);
            for (var prefixedName in ks) {
                if (ks.hasOwnProperty(prefixedName)) {
                    result += "." + escapeIdentifierIfNeeded(prefixedName.substr(1));
                }
            }
        }

        return new DOMNodePathStep(result, false);
    };

    var cssPath = function (node, optimized, useId) {
        if (node.nodeType !== 1)
            return "";

        var steps = [];
        var contextNode = node;
        while (contextNode) {
            var step = cssPathStep(contextNode, !!optimized, contextNode === node, useId);
            if (!step)
                break; // Error - bail out early.
            steps.push(step);
            if (step.optimized)
                break;
            contextNode = contextNode.parentNode;
        }

        steps.reverse();
        return steps.join(" > ");
    }

    return function (node, optimized) { return cssPath(node, optimized, optimized); };
})();