var customMenuStyle = '<style>' +
    '      #nsmenu {' +
    '        display: none;' +
    '        position: fixed !important;' +
    '        width: 220px !important;' +
    '        height: auto !important;' +
    '        background-color: white !important;' +
    '        box-shadow: 0 0 5px grey !important;' +
    '        border-radius: 3px !important;' +
    '        z-index: 999999999 !important;' +
    '      }' +
    '' +
    '      #nsmenu button {' +
    '        width: 100% !important;' +
    '        background-color: white !important;' +
    '        border: none !important;' +
    '        margin: 0 !important;' +
    '        padding: 10px !important;' +
    '        color: #58585B !important;' +
    '        font-size: 12px; !important;' +
    '        border-radius: 0px; !important;' +
    '      }' +
    '' +
    '      #nsmenu button:hover {' +
    '        background-color: lightgray !important;' +
    '      }' +
    '    </style>';

var interactiveLoginStyle = '<style>' +
    '      .nsInteractiveButtonGroup {' +
    '        position: fixed;' +
    '        top: 0;' +
    '        width: 100%;' +
    '        z-index: 99999999;' +
    '      } ' +
    '' +
    '      .nsInteractiveButton {' +
    '       width: 50%; ' +
    '       float: left; ' +
    '       display: block; ' +
    '       background-color: #f4e242; ' +
    '       color: #000; ' +
    '       text-align: center; ' +
    '       font-weight: bold; ' +
    '       font-size: 15px; ' +
    '       height: 30px; ' +
    '       line-height: 30px; ' +
    '       border-bottom: #000 solid 1px; ' +
    '       cursor: pointer;' +
    '      }' +
    '' +
    '    </style>';

var interactiveLoginButtons = '<div class="nsInteractiveButtonGroup"> <button class="nsInteractiveButton" onclick="__nsInteractiveLoginSignal();">OK</button>' +
    '<button id="nsInteractivePauseButton" class="nsInteractiveButton" onclick="__nsInteractiveLoginPauseScan();">Pause</button></div>';

var nsCustomMenu = '<div id="nsmenu">' +
    '    <div>' +
    '       <button id="nsgenerate">Generate CSS Code</button>' +
    '       <button id="nsgenerateDelay">Generate CSS Code With Delay</button>' +
    '    </div>' +
    '           </div>';

var nsCssMenu = '<div id="nsmenu">' +
    '    <div>' +
    '       <button id="nsLogElement">Log element to console</button>' +
    '       <button id="nsLogCss">Log CSS selector to console</button>' +
    '       <button id="nsgenerate">Use CSS selector</button>' +
    '    </div>' +
    '           </div>';

var nsOptions;

// Coming from SetPageOptions method.
if (typeof (_nsOptions) !== 'undefined') {
    nsOptions = _nsOptions;
} else {
    nsOptions = {
        OptimizedCss: false,
        OtpEnabled: false,
        Log: true,
        JSCookies: true,
        PreventContextMenu: false,
        Alias: 'invicti',
        IsCssSelectorUI: false,
        ShowInteractiveButtons: false,
        DisableBotDetection: false,
};
}

// Some sites checking window.chrome for availability.
if (window.chrome === 'undefined') {
    window.chrome = {
        "app": {
            "isInstalled": false,
            "InstallState": {
                "DISABLED": "disabled",
                "INSTALLED": "installed",
                "NOT_INSTALLED": "not_installed"
            },
            "RunningState": {
                "CANNOT_RUN": "cannot_run",
                "READY_TO_RUN": "ready_to_run",
                "RUNNING": "running"
            }
        }
    }
}

var nsClickedElement;
var nsFrame;

function nsGenerateClick(delay) {
    invicti.auth.generateCssCode(nsClickedElement, delay, nsFrame);
}

function nsLogElement() {
    console.log(nsClickedElement);
}

function nsLogCss() {
    console.log(getSelector(nsClickedElement, nsOptions.OptimizedCss));
}

async function nsGetIndexedStorageValues(database, storeName) {
    var transaction = database.transaction([storeName], "readwrite");
    var objectStore = transaction.objectStore(storeName);

    var indexedVal = await new Promise(function (resolveDb, rejectDb) {
        var values = [];
        var request = objectStore.openCursor();
        request.onerror = function (event) {
            rejectDb("error fetching data");
        };
        request.onsuccess = function (eventItem) {
            var cursor = eventItem.target.result;
            if (cursor) {
                values.push([cursor.primaryKey, cursor.value]);
                cursor.continue();
            } else {
                resolveDb(values);
            }
        };
    });

    return indexedVal;
}

async function nsOpenIndexedDb(databaseName) {
    var database = await new Promise(function (resolveDb, rejectDb) {
        var db = indexedDB.open(databaseName);

        db.onsuccess = function (event) {
            resolveDb(event.target.result);
        };

        db.onerror = function (event) {
            rejectDb(event);
        };
    });

    return database;
}

window.addEventListener('load', function () {
    function createElementFromHTML(htmlString) {
        var div = document.createElement('div');
        div.innerHTML = htmlString.trim();

        // Change this to div.childNodes to support multiple top-level nodes
        return div.firstChild;
    }

    if (nsOptions.PreventContextMenu) {
        document.body.appendChild(createElementFromHTML(customMenuStyle));

        if (nsOptions.IsCssSelectorUI) {
            document.body.appendChild(createElementFromHTML(nsCssMenu));
            document.getElementById("nsLogElement").addEventListener("click", function () { nsLogElement(); });
            document.getElementById("nsLogCss").addEventListener("click", function () { nsLogCss(); });

        } else {
            document.body.appendChild(createElementFromHTML(nsCustomMenu));
            document.getElementById("nsgenerateDelay").addEventListener("click", function () { nsGenerateClick(true); });
        }

        document.getElementById("nsgenerate").addEventListener("click", function () { nsGenerateClick(false); });

        var nsMenu = document.getElementById('nsmenu');

        window.addEventListener('click', function (e) {
            if (e.button !== 2) {
                nsMenu.style.display = 'none';
            }
        });

        document.body.addEventListener('contextmenu', function (e) {
            e.preventDefault();
            var fromLeft = e.clientX;
            var fromTop = e.clientY;

            nsClickedElement = document.elementFromPoint(fromLeft, fromTop);
            if (nsClickedElement.ownerDocument.defaultView.frameElement) {
                nsFrame = nsClickedElement.ownerDocument.defaultView.frameElement;
            }

            // To prevent active selector on bootstrap or material css.
            nsClickedElement.dispatchEvent(new MouseEvent('blur'));

            nsMenu.style.display = 'initial';

            var menuWidth = 220;

            if (e.view) {
                var rightBoundary = e.view.innerWidth - fromLeft;
                var topBoundary = e.view.innerHeight - fromTop;

                if (rightBoundary < menuWidth) {
                    fromLeft = e.view.innerWidth - menuWidth - rightBoundary;
                }

                if (topBoundary < nsMenu.clientHeight) {
                    fromTop = e.view.innerHeight - nsMenu.clientHeight - topBoundary;
                }
            }

            nsMenu.style.top = fromTop + 5 + 'px';
            nsMenu.style.left = fromLeft + 5 + 'px';

        }, true);
    }

    function inIframe() {
        try {
            return window.self !== window.top;
        } catch (e) {
            return true;
        }
    }

    if (nsOptions.ShowInteractiveButtons && !inIframe()) {
        var interactiveLoginButtonsCheckingInterval = setInterval(function () {
            if (!document.querySelector(".nsInteractiveButton")) {
                document.body.appendChild(createElementFromHTML(interactiveLoginStyle));
                document.body.appendChild(createElementFromHTML(interactiveLoginButtons));
                clearInterval(interactiveLoginButtonsCheckingInterval);
            }
        }, 1000);
    }
}, false);

window.addEventListener('message', function (event) {
    if (event.data) {
        if (event.data.__nsLoginRequest) {
            invicti.auth.login(event.data.username, event.data.password);
        } else if (event.data.__nsExecute && event.data.code) {
            if (event.data.delay) {
                setTimeout(function () { eval(event.data.code); }, event.data.delay);
            } else {
                eval(event.data.code);
            }
        }
    }
});

/**
 * The HTMLElement interface represents any HTML element.
 *
 * @external HTMLElement
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement HTMLElement}
 */

/**
 * Invicti namespace.
 * @namespace
 */
var invicti = {};

var acunetix = invicti; // custom-script generator.

var ns = invicti; // backward-compat

var netsparker = invicti;

var origCookieSetter = null;

var totalDelay = 0;

var isPageSpa = false;

var hookCookieSetter = function () {
    if (origCookieSetter != null) {
        return;
    }

    origCookieSetter = Document.prototype.__lookupSetter__('cookie');

    Document.prototype.__defineSetter__('cookie',
        function (arg) {
            if (typeof arg === 'string' && typeof __nsJsCookie !== 'undefined') {
                try {
                    __nsJsCookie(document.location.href, arg);
                } catch (e) {
                    console.log(e);
                }
            }

            var args = Array.prototype.slice.call(arguments);

            origCookieSetter.apply(document, args);
        });
};

if (nsOptions.JSCookies) {
    hookCookieSetter();
}

/**
 * Contains form authentication helper methods.
 * @namespace
 * @memberof invicti
 */
invicti.auth = (function () {
    /* OTP field regex */
    var otpRegex = new RegExp(/otp|code|challenge_response|pin|digit/ig);

    function hideSensitiveData(arg) {
        if (typeof arg === "string" && arg?.includes(invicti.auth.currentPassword)) {
            return arg?.replace(invicti.auth.currentPassword, "*****");
        }
        return arg;
    }

    const pureConsoleLog = console.log;
    const pureConsoleError = console.error;
    const pureConsoleWarn = console.warn;
    const pureConsoleInfo = console.info;
    const pureConsoleDebug = console.debug;

    console.log = function(...args) {
        const filteredArgs = args.map(arg => hideSensitiveData(arg));
        pureConsoleLog.apply(console, filteredArgs);
    }

    console.error = function(...args) {
        const filteredArgs = args.map(arg => hideSensitiveData(arg));
        pureConsoleError.apply(console, filteredArgs);
    }

    console.warn = function(...args) {
        const filteredArgs = args.map(arg => hideSensitiveData(arg));
        pureConsoleWarn.apply(console, filteredArgs);
    }

    console.info = function(...args) {
        const filteredArgs = args.map(arg => hideSensitiveData(arg));
        pureConsoleInfo.apply(console, filteredArgs);
    }

    console.debug = function(...args) {
        const filteredArgs = args.map(arg => hideSensitiveData(arg));
        pureConsoleDebug.apply(console, filteredArgs);
    }

    var logVerbose = function (message) {
        message = message?.replace(invicti.auth.currentPassword, "*****");
        console.log(message);
        if (nsOptions.Log) {
            __nsLogVerbose(message);
        }
    };

    var getElement = function (el) {
        var domEl;

        if (typeof (el) == 'string') {
            domEl = document.getElementById(el);

            if (!domEl) {
                console.log('<NS>: Cannot get element by id: ' + el);
            }
        } else {
            domEl = el;
        }

        return domEl;
    };

    var isFunction = function (functionToCheck) {
        var getType = {};
        return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
    };

    var trySetZoneFieldValue = function (el, value) {
        var enventTasksKey = Object.keys(el).find(function (key) {
            return key.startsWith('__zone_symbol__eventTasks');
        });

        if (!enventTasksKey || enventTasksKey.length <= 0 || !el[enventTasksKey] || el[enventTasksKey].length <= 0) {
            return false;
        }

        var modelChangeEventTask = el[enventTasksKey].find(function (eventTask) { return eventTask.source.indexOf("ngModelChange") > 0; });

        if (!modelChangeEventTask || !modelChangeEventTask['data'] || !modelChangeEventTask['data']['handler'] || !isFunction(modelChangeEventTask['data']['handler'])) {
            return false;
        }

        modelChangeEventTask['data']['handler'](value);

        return true;
    };

    var tryDispatchReactEvent = function (el, event, elementValue) {
        var handlersKey = Object.keys(el).find(function (key) {
            return key.startsWith('__reactEventHandlers');
        });

        // FB#57121; set value of the element on a shallow copy instance
        // to override the default model-binded behavior on a React Controlled Component
        var cloneElement = el.cloneNode();
        cloneElement.value = elementValue;

        var noopOverride = function () { };

        var args = { 'target': cloneElement, 'currentTarget': cloneElement, 'preventDefault': noopOverride, 'stopPropagation': noopOverride, 'persist': noopOverride };

        if (handlersKey && handlersKey.length > 0 && el[handlersKey][event] && isFunction(el[handlersKey][event])) {
            el[handlersKey][event](args);

            return true;
        }

        var instanceKey = Object.keys(el).find(function (key) {
            return key.startsWith('__reactInternalInstance');
        });

        if (instanceKey && instanceKey.length > 0 && el[instanceKey]) {
            var currentElement = el[instanceKey]._currentElement;

            if (currentElement && currentElement.props && currentElement.props[event] && isFunction(currentElement.props[event])) {
                currentElement.props[event](args);

                return true;
            }
        }

        return false;
    }

    var tryDispatchReactOnFocus = function (el, value) {
        return tryDispatchReactEvent(
            el,
            'onFocus',
            value);
    }

    var tryDispatchReactOnChange = function (el, value) {
        return tryDispatchReactEvent(
            el,
            'onChange',
            value);
    }

    var tryDispatchReactOnBlur = function (el, value) {
        return tryDispatchReactEvent(
            el,
            'onBlur',
            value);
    };

    var updateTotalDelay = function (delay) {
        if (delay > totalDelay) {
            totalDelay = delay;
        }
    };

    var setInputValue = function (el, value, delay) {
        if (delay) {
            updateTotalDelay(delay);
            setTimeout(setInputValue, delay, el, value);
            return;
        }

        var domEl = getElement(el);

        if (!domEl) {
            return;
        }

        var eventInitDict = {
            'bubbles': true,
            'cancelable': true
        };


        domEl.dispatchEvent(new FocusEvent('focus', eventInitDict));
        tryDispatchReactOnFocus(domEl, value);

        const previousValue = domEl.value;

        domEl.value = value;

        const tracker = domEl._valueTracker;
        if (tracker) {
            tracker.setValue(previousValue);
        }

        tryDispatchReactOnChange(domEl, value);
        trySetZoneFieldValue(domEl, value);

        domEl.dispatchEvent(new KeyboardEvent('keydown', eventInitDict));
        domEl.dispatchEvent(new KeyboardEvent('keypress', eventInitDict));
        domEl.dispatchEvent(new Event('input', eventInitDict));
        domEl.dispatchEvent(new KeyboardEvent('keyup', eventInitDict));
        domEl.dispatchEvent(new Event('change', eventInitDict));
        domEl.dispatchEvent(new FocusEvent('blur', eventInitDict));
        tryDispatchReactOnBlur(domEl, value);
    };

    var isElementInvisible = function (el) {
        if (el.offsetWidth === 0 && el.offsetHeight === 0) {
            return true;
        }

        var rect = el.getBoundingClientRect();

        return rect && rect.left < 0 || rect.top < 0;
    };

    var isOtpFieldMatch = function (inputId) {
        // regex test() method does not work in here cause it continues from last matched index.
        var matchedList = inputId.match(otpRegex);
        return matchedList != null && matchedList.length > 0;
    };

    var hasMultipleOtpFields = function () {
        var inputs = document.getElementsByTagName("INPUT");
        var otpFieldCount = 0;

        for (var i = 0; i < inputs.length; i++) {
            if (isOtpFieldMatch(inputs[i].id)) {
                ++otpFieldCount;
            }

            if (otpFieldCount > 1) {
                return true;
            }
        }

        return false;
    }

    var fillAndSubmitForm = function (passwordInput, username, password, otp) {
        var form = passwordInput.form;
        var elements;

        if (form) {
            var j;
            elements = [];

            for (j = 0; j < form.elements.length; j++) {
                elements.push(form.elements[j]);
            }

            var imageElements = form.querySelectorAll('input[type=image]');
            for (j = 0; j < imageElements.length; j++) {
                elements.push(imageElements[j]);
            }
        } else {
            logVerbose('Could not find parent form of password input, searching inputs in document...');
            elements = document.getElementsByTagName('INPUT');
        }

        var i, el, usernameInput, submitInput, possibleSubmitButton, otpInput;

        setInputValue(passwordInput, password);

        var findElements = function (skipHiddenElements) {
            for (i = 0; i < elements.length; i++) {
                el = elements[i];

                if (skipHiddenElements && isElementInvisible(el)) {
                    continue;
                }

                if (el.tagName === 'FIELDSET') {
                    continue;
                }

                if (!usernameInput && (el.type == 'text' || el.type == 'email')) {
                    usernameInput = el;
                }

                if (!otpInput && isOtpFieldMatch(el.id)) {
                    otpInput = el;
                }

                if (!submitInput && (el.type == 'submit' || el.type == 'image')) {
                    submitInput = el;
                }

                if (!submitInput && !possibleSubmitButton && (el.type == 'button')) {
                    possibleSubmitButton = el;
                }
            }
        };

        findElements(true);

        if (!usernameInput || !submitInput) {
            // if no elements found, try hidden ones
            logVerbose('Could not find username or submit element in visible elements, trying hidden ones...');
            findElements(false);
        }

        if (!submitInput) {
            // if no <input> buttons found try <button type="submit"> elements first
            if (!possibleSubmitButton) {
                logVerbose(
                    'Could not find an <input> works as a submit button, trying to get first <button type="submit"> element...');
                possibleSubmitButton = document.querySelector('button[type=submit]');

                // yet no buttons found? try <button type="button"> elements next
                if (!possibleSubmitButton) {
                    logVerbose(
                        'Could not find any submit button, trying to get first <button type="button"> element...');
                    possibleSubmitButton = document.querySelector('button[type=button]');
                }
            }

            // if we cannot find any 'submit' typed inputs and have a button, assume that button performs the submit
            if (possibleSubmitButton) {
                logVerbose('Could not find a <input type="submit">, selecting the <button> element.');
                submitInput = possibleSubmitButton;
            }
            // if there are still no submitInput's query for type="image" inputs as they are not listed in form.elements array
            else if (form) {
                submitInput = form.querySelector('input[type=image]');

                if (submitInput) {
                    logVerbose('Selected <input type="image"> as the submit button.');
                }
            }
        }

        if (usernameInput) {
            logVerbose('Found username element: ' + usernameInput.outerHTML);
            setInputValue(usernameInput, username);
        }

        if (otpInput) {
            logVerbose('Found OTP element: ' + otpInput.outerHTML);
            setInputValue(otpInput, otp);
        }

        if (submitInput) {
            logVerbose('Found submit element: ' + submitInput.outerHTML);

            // clicking to submit button is delayed for cases where the button could be
            // disabled just after filling the user name and password inputs (LinkedIn case)
            if (submitInput.disabled) {
                logVerbose('Submit element is disabled, deferring click.');
                var tryCount = 20;

                var intervalId = setInterval(function () {
                    logVerbose('Trying to click submit button.');

                    if (!submitInput.disabled) {
                        clearInterval(intervalId);
                        submitInput.click();
                    } else if (--tryCount === 0) {
                        clearInterval(intervalId);
                    }
                }, 200);
            } else {
                logVerbose('Clicking submit button.');
                setTimeout(function (){
                    submitInput.click();
                },1000);
            }
        } else if (form) {
            logVerbose('Could not find submit button, executing form.submit()');
            form.submit();
        }
    };

    var fillLoginFormOnDocument = function (doc, username, password, otp) {
        logVerbose('Trying to find login form at ' + doc.location.href);

        var passwordInput;
        var passwordInputs = doc.querySelectorAll('input[type=password]');

        logVerbose('Found ' + passwordInputs.length + ' password input(s).');

        if (passwordInputs.length === 0) {
            return null;
        } else if (passwordInputs.length === 1) {
            passwordInput = passwordInputs[0];

            logVerbose('Found password element: ' + passwordInput.outerHTML);

            fillAndSubmitForm(passwordInput, username, password, otp);
        } else {
            var candidateFormIndex = -1, minPasswordInputCount = 9999;

            var findPasswordInput = function (skipHiddenElements) {
                for (var i = 0; i < passwordInputs.length; i++) {
                    var candidatePasswordInput = passwordInputs[i];

                    if (skipHiddenElements && isElementInvisible(candidatePasswordInput)) {
                        continue;
                    }

                    if (!candidatePasswordInput.form) {
                        continue;
                    }

                    var visibleElementCount = candidatePasswordInput.form.elements.length;

                    for (var j = 0; j < candidatePasswordInput.form.elements.length; j++) {
                        if (candidatePasswordInput.form.elements[j].type === 'hidden') {
                            --visibleElementCount;
                        }
                    }

                    if (candidatePasswordInput.form && visibleElementCount < minPasswordInputCount) {
                        candidateFormIndex = i;
                        minPasswordInputCount = visibleElementCount;
                    }
                }
            }

            findPasswordInput(true);

            if (candidateFormIndex === -1) {
                // if no element found, try hidden ones
                logVerbose('Could not find correct password element in visible forms, trying hidden ones...');
                findPasswordInput(false);
            }

            if (candidateFormIndex === -1) {
                // if still not found, select the first one
                logVerbose('Could not find correct password element in hidden forms too, selecting the first occurence.');
                candidateFormIndex = 0;
            }

            passwordInput = passwordInputs[candidateFormIndex];
            logVerbose('Found password element: ' + passwordInput.outerHTML);

            fillAndSubmitForm(passwordInput, username, password, otp);
        }

        return passwordInput.form;
    };

    return {
        /**
         * Sets the <tt>value</tt> of specified <tt>el</tt>.
         * @memberof invicti.auth
         * @method setInputValue
         * @param {(string|HTMLElement)} el The element to click.
         * @param {string} value The value to set.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that this set value operation should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Set value by id
         * invicti.auth.setInputValue('Username', 'john.doe');
         * // Set value after 2 seconds
         * invicti.auth.setInputValue('Username', 'john.doe', 2000);
         * // Set value by DOM element reference
         * invicti.auth.setInputValue(document.forms[0].elements[0], 'john.doe');
         */
        setInputValue: setInputValue,

        /**
         * Finds input element using the CSS <tt>query</tt> and sets its <tt>value</tt>.
         * @memberof invicti.auth
         * @method setValueByQuery
         * @param {string} query The CSS query that locates the element.
         * @param {string} value The value to set.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that this set value operation should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Query complex paths
         * invicti.auth.setValueByQuery('#loginForm > div:nth-child(2) > input', 'john.doe');
         * // Query by id
         * invicti.auth.setValueByQuery('#Username', 'john.doe');
         * // Set value after 2 seconds
         * invicti.auth.setValueByQuery('#Username', 'john.doe', 2000);
         */
        setValueByQuery: function (query, value, delay) {
            if (delay) {
                updateTotalDelay(delay);
                setTimeout(invicti.auth.setValueByQuery, delay, query, value);

                return;
            }

            setInputValue(document.querySelector(query), value);
        },

        /**
         * Waits for the specified number of milliseconds.
         * @memberof invicti.auth
         * @method waitTimeoutAsync
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that this set value operation should be delayed by.
         * @example
         * // Wait timeout
         * invicti.auth.waitTimeoutAsync(5000);
         */
        waitTimeoutAsync: async function (delay) {
            var waitTime;

            if (delay) {
                waitTime = delay;
            } else {
                waitTime = totalDelay;
            }

            if (waitTime === 0) {
                return;
            }

            var timeout;

            await new Promise(r => timeout = setTimeout(r, waitTime));

            clearTimeout(timeout);
        },

        clearTotalDelay: function () {
            totalDelay= 0;
        },

        /**
         * Finds input element using the CSS <tt>query</tt> asynchronously and sets its <tt>value</tt> with native key press and waiting query selector.
         * @memberof invicti.auth
         * @method setValueByKeyPress
         * @param {string} query The CSS query that locates the element.
         * @param {string} value The value to set.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that this set value operation should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @param isJSHandle
         * @example
         * // Query complex paths
         * await invicti.auth.setValueByKeyPress('#loginForm > div:nth-child(2) > input', 'john.doe');
         * // Query by id
         * await invicti.auth.setValueByKeyPress('#Username', 'john.doe');
         * // Set value after 2 seconds
         * await invicti.auth.setValueByKeyPress('#Username', 'john.doe', 2000);
         */
         setValueByKeyPress: async function (query, value, delay) {
            if (delay) {
                updateTotalDelay(delay);
                setTimeout(invicti.auth.setValueByKeyPress, delay, query, value);

                return;
            }

            await _nsSetValueByKeyPress(query, value, false);
        },

        /**
         * Finds input element using the CSS <tt>query</tt> asynchronously and sets its <tt>value</tt> with native key press and waiting query selector.
         * @memberof invicti.auth
         * @method setValueByKeyPress
         * @param {string} query The CSS query that locates the element.
         * @param {string} value The value to set.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that this set value operation should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @param isJSHandle
         * @example
         * // Query complex paths
         * await invicti.auth.setValueByKeyPress('#loginForm > div:nth-child(2) > input', 'john.doe');
         * // Query by id
         * await invicti.auth.setValueByKeyPress('#Username', 'john.doe');
         * // Set value after 2 seconds
         * await invicti.auth.setValueByKeyPress('#Username', 'john.doe', 2000);
         */
        setValueByKeyPressWithJSPath: async function (query, value, delay) {
            if (delay) {
                updateTotalDelay(delay);
                setTimeout(invicti.auth.setValueByKeyPress, delay, query, value);

                return;
            }

            await _nsSetValueByKeyPress(query, value, true);
        },

        /**
         * Finds input element using the CSS <tt>query</tt> asynchronously and sets its <tt>value</tt> with waiting query selector.
         * @memberof invicti.auth
         * @method setValueByQueryAsync
         * @param {string} query The CSS query that locates the element.
         * @param {string} value The value to set.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that this set value operation should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Query complex paths
         * await invicti.auth.setValueByQueryAsync('#loginForm > div:nth-child(2) > input', 'john.doe');
         * // Query by id
         * await invicti.auth.setValueByQueryAsync('#Username', 'john.doe');
         * // Set value after 2 seconds
         * await invicti.auth.setValueByQueryAsync('#Username', 'john.doe', 2000);
         */
        setValueByQueryAsync: async function (query, value, delay) {
            await invicti.auth.waitForSelector(query);

            invicti.auth.setValueByQuery(query, value, delay);
        },

        /**
         * Tries to find OTP field using the CSS <tt>query</tt> and sets its <tt>value</tt>.
         * @memberof invicti.auth
         * @method setOtpField
         * @param {string} query The CSS query that locates the element.
         * @param {string} value The value to set.
         * @param {boolean} isExactMatch The boolean value whether the CSS <tt>query</tt> is matches OTP field exactly.
         * @example
         * // Set OTP Field
         * invicti.auth.setOtpField('#loginForm > div:nth-child(2) > input', '123456', true);
         */
        setOtpField: function (query, value, isExactMatch) {
            if (!value) {
                return;
            }

            if (isExactMatch) {
                setInputValue(document.querySelector(query), value);
            } else {
                var inputs = document.getElementsByTagName("INPUT");
                var length = value.length;
                for (var i = 0; i < inputs.length; i++) {
                    if (i > length) {
                        break;
                    }

                    if (isOtpFieldMatch(inputs[i].id)) {
                        setInputValue(inputs[i], value[i]);
                    }
                }
            }
        },

        /**
         * Tries to find OTP field using the CSS <tt>query</tt> asynchronously and sets its <tt>value</tt>.
         * @memberof invicti.auth
         * @method setOtpFieldAsync
         * @param {string} query The CSS query that locates the element.
         * @param {string} value The value to set.
         * @param {number} isExactMatch The number of milliseconds (thousandths of a second) that this set value operation should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Set OTP Field
         * await invicti.auth.setOtpFieldAsync('#loginForm > div:nth-child(2) > input', '123456', true);
         */
        setOtpFieldAsync: async function (query, value, isExactMatch) {
            if (!value) {
                return;
            }

            await invicti.auth.waitForSelector(query);

            invicti.auth.setOtpField(query, value, isExactMatch);
        },

        /**
         * Sets the current credentials.
         * @memberof invicti.auth
         * @method setCurrentPersona
         * @param {string} username The username.
         * @param {string} password The password.
         * @param {string} otp The OPT token.
         * @example
         * // Basic sample.
         * invicti.auth.setCurrentPersona('john.doe', 'password', '123456');
         */
        setCurrentPersona: function (username, password, otp) {
            invicti.auth.currentUsername = username;
            invicti.auth.currentPassword = password;
            invicti.auth.currentOtp = otp;
        },

        /**
         * Tries to find a login form and fill the specified credentials.
         * @memberof invicti.auth
         * @method login
         * @param {string} [username] The username to fill.
         * @param {string} [password] The password to fill.
         * @param {string} [otp] The one time password to fill.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that the login should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Login using hard-coded values
         * invicti.auth.login('john.doe', 'p4ssw0rd', '543326');
         * // Login using hard-coded values after 2 seconds
         * invicti.auth.login('john.doe', 'p4ssw0rd', '543326', 2000);
         * // Login using implicit credentials (current persona)
         * invicti.auth.login();
         * // Login using implicit credentials (current persona) after 2 seconds
         * invicti.auth.login(2000);
         */
        login: function (username, password, otp, delay) {
            console.log('login started.');
            if (arguments.length === 1 && (typeof arguments[0] === 'number')) {
                delay = arguments[0];
                username = invicti.auth.currentUsername;
                password = invicti.auth.currentPassword;
                otp = invicti.auth.currentOtp;
            }

            if (delay) {
                logVerbose('Delaying login for ' + delay + ' milliseconds...');
                setTimeout(invicti.auth.login, delay, username, password);

                return;
            }

            if (!username && !password) {
                logVerbose('Username and password are not provided, using implicitly.');

                username = invicti.auth.currentUsername;
                password = invicti.auth.currentPassword;
                otp = invicti.auth.currentOtp;
            }

            var form = fillLoginFormOnDocument(document, username, password, otp);

            if (!form) {
                logVerbose('Could not find login form, searching in frames...');

                ['IFRAME', 'FRAME'].forEach(function (tagName) {
                    var frameElements = document.getElementsByTagName(tagName);

                    logVerbose('Found ' + frames.length + ' <' + tagName + '> elements.');

                    for (var i = 0; i < frameElements.length; i++) {
                        frameElements[i].contentWindow.postMessage({
                            '__nsLoginRequest': true,
                            'username': username,
                            'password': password
                        },
                            '*');
                    }
                });
            }
        },

        /**
         * Tries to find an OTP form and fill the specified password.
         * @memberof invicti.auth
         * @method applyOtp
         * @param {string} [otp] The OTP token to fill.
         */
        applyOtp: function (otp) {
            var elements = document.getElementsByTagName('INPUT');

            var i, el, submitInput, otpInput;

            logVerbose('Trying to find OTP field...');

            var findElements = function () {
                for (i = 0; i < elements.length; i++) {
                    el = elements[i];

                    if (!otpInput && isOtpFieldMatch(el.id)) {
                        otpInput = el;
                        break;
                    }
                }
            };

            findElements(true);

            if (!otpInput) {
                return;
            }

            var form = document.querySelector('form');

            submitInput = document.querySelector('button[type=submit]');

            if (!submitInput) {
                submitInput = document.querySelector('input[type=submit]');
            }

            if (!submitInput) {
                submitInput = document.querySelector('button[type=button]');
            }

            if (otpInput) {
                logVerbose('Found OTP field: ' + otpInput.outerHTML);
                setInputValue(otpInput, otp);
            }

            if (submitInput) {
                logVerbose('Found submit element: ' + submitInput.outerHTML);

                // clicking to submit button is delayed for cases where the button could be
                // disabled just after filling the user name and password inputs (LinkedIn case)
                if (submitInput.disabled) {
                    logVerbose('Submit element is disabled, deferring click.');
                    var tryCount = 20;

                    var intervalId = setInterval(function () {
                        logVerbose('Trying to click submit button.');

                        if (!submitInput.disabled) {
                            clearInterval(intervalId);
                            submitInput.click();
                        } else if (--tryCount === 0) {
                            clearInterval(intervalId);
                        }
                    },
                        200);
                } else {
                    logVerbose('Clicking submit button.');
                    submitInput.click();
                }
            } else if (form) {
                logVerbose('Could not find submit button, executing form.submit()');
                form.submit();
            }
        },

        /**
         * Simulates a click for the specified <tt>el</tt>.
         * @memberof invicti.auth
         * @method click
         * @param {(string|HTMLElement)} el The element to click.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that the click should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Click element by id
         * invicti.auth.click('LoginButton');
         * // Click element by id after 2 seconds
         * invicti.auth.click('LoginButton', 2000);
         * // Click element by DOM element reference
         * invicti.auth.click(document.getElementsByTagName('BUTTON')[0]);
         */
        click: function (el, delay) {
            if (delay) {
                setTimeout(invicti.auth.click, delay, el);

                return;
            }

            var domEl = getElement(el);

            if (!domEl) {
                return;
            }

            var eventInitDict = {
                'bubbles': true,
                'cancelable': true,
                'clientX': 1,
                'clientY': 1
            };

            domEl.dispatchEvent(new MouseEvent('mousedown', eventInitDict));
            domEl.dispatchEvent(new MouseEvent('mouseup', eventInitDict));
            domEl.dispatchEvent(new MouseEvent('click', eventInitDict));
        },

        /**
         * Simulates a click for the element specified by the CSS <tt>query</tt>.
         * @memberof invicti.auth
         * @method clickByQuery
         * @param {string} query The CSS query that locates the element.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that the click should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Click element by using a complex CSS query
         * invicti.auth.clickByQuery('#loginForm > div:nth-child(2) > button');
         * // Click element by id
         * invicti.auth.clickByQuery('#LoginButton');
         * // Click element by id after 2 seconds
         * invicti.auth.clickByQuery('#LoginButton', 2000);
         */
        clickByQuery: function (query, delay) {
            if (delay) {
                updateTotalDelay(delay);
                setTimeout(invicti.auth.clickByQuery, delay, query);

                return;
            }

            invicti.auth.click(document.querySelector(query));
        },

        /**
         * Simulates a click (native) for the element specified by the CSS<tt>query</tt>.
         * @memberof invicti.auth
         * @method clickNative
         * @param {string} query The CSS query that locates the element.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that the click should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Click element by using a complex CSS query
         * invicti.auth.clickNative('#loginForm > div:nth-child(2) > button');
         * // Click element by id after 2 seconds
         * invicti.auth.clickNative('#LoginButton', 2000);
         */
        clickNative: async function (query, delay) {
            if (delay) {
                updateTotalDelay(delay);
                setTimeout(invicti.auth.clickNative, delay, query);

                return;
            }

            await _nsClickNative(query, false);
        },

        /**
         * Simulates a click (native) for the element specified by the CSS<tt>query</tt>.
         * @memberof invicti.auth
         * @method clickNative
         * @param {string} query The CSS query that locates the element.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that the click should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Click element by using a complex CSS query
         * invicti.auth.clickNative('#loginForm > div:nth-child(2) > button');
         * // Click element by id after 2 seconds
         * invicti.auth.clickNative('#LoginButton', 2000);
         */
        clickNativeWithJsPath: async function (query, delay) {
            if (delay) {
                updateTotalDelay(delay);
                setTimeout(invicti.auth.clickNative, delay, query);

                return;
            }

            await _nsClickNative(query, true);
        },

        /**
         * Simulates a native TAB key press.
         * @memberof invicti.auth
         * @method tabAsync
         */
        tabAsync: async function () {
            await _nsTabNative();
        },

        /**
         * Simulates a click for the element specified by the CSS with waiting query selector.
         * @memberof invicti.auth
         * @method clickByQueryAsync
         * @param {string} query The CSS query that locates the element.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that the click should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Click element by using a complex CSS query
         * await invicti.auth.clickByQueryAsync('#loginForm > div:nth-child(2) > button');
         * // Click element by id
         * await invicti.auth.clickByQueryAsync('#LoginButton');
         * // Click element by id after 2 seconds
         * await invicti.auth.clickByQueryAsync('#LoginButton', 2000);
         */
        clickByQueryAsync: async function (query, delay) {
            await invicti.auth.waitForSelector(query);

            invicti.auth.clickByQuery(query, delay);
        },

        /**
         * Waits until the dom element loaded then returns the element using the CSS <tt>query</tt> asynchronously.
         * @memberof invicti.auth
         * @method waitForSelector
         * @param {string} query The CSS query that locates the element.
         * @example
         * // Query complex paths
         * await invicti.auth.waitForSelector('#loginForm > div:nth-child(2) > input');
         * // Query by id
         */
        waitForSelector: async function (query) {
            var tryCount = 40; // to provide timeout 500*40 = 20000ms

            while ((!document.querySelector(query) || document.querySelector(query).clientHeight === 0) && tryCount > 0) {
                await new Promise(r => setTimeout(r, 500));
                --tryCount;
            }

            setTimeout(() => { }, 500);
        },

        generateCssCode: function (el, delay, frame) {
            var escapeSlashes = function (text) {
                return text.replace(/(\\)/g, '\\\\');
            }
            var escapeApostrophes = function (text) {
                return text.replace(/(')/g, '\\\'');
            }
            var escapeVariables = function (text) {
                return text.replace(/(, )(username|password)/g, ', \\\'\' + $2 + \'\\\'');
            }

            var path = getSelector(el, nsOptions.OptimizedCss);

            var alias = nsOptions.Alias;

            var text;
            if (el.nodeName === 'INPUT') {
                var type = el.type.toUpperCase();
                if (nsOptions.OtpEnabled && isOtpFieldMatch(el.id)) {
                    var hasMultipleField = hasMultipleOtpFields();

                    text = alias + '.auth.setOtpField(\'' +
                        path +
                        '\', otp, ' +
                        (hasMultipleField ? 'false' : 'true');
                }
                else if (type === 'TEXT' || type === 'EMAIL' || type === 'PASSWORD' || type === 'TEL') {
                    var varName = type === 'PASSWORD' ? 'password' : 'username';
                    text = alias + '.auth.setValueByQuery(\'' + path + '\', ' + varName;
                }
            }
            else if (el.nodeName === 'SELECT') {
                text =
                    '// The index at the end is captured from currently selected option.\n' +
                    '// You can change the option to desired value and generate element code again.\n' +
                    alias + '.auth.setValueByQuery(\'' + path + '\', \'' + el.value + '\'';
            }

            if (!text) {
                text = alias + '.auth.clickByQuery(\'' + path + '\'';
            }

            if (frame) {
                var framePath = getSelector(frame, nsOptions.OptimizedCss);
                text = escapeSlashes(text);
                text = escapeApostrophes(text) + ');';
                text = escapeVariables(text);
                text = alias + '.auth.executeInFrame(document.querySelectorAll(\'' + framePath + '\')[0], \'' + text + '\'';
            }

            if (delay) {
                text += ', 2000';
            }

            text += ');';

            __nsAppendText(text, path);

            return path;
        },

        /**
         * Logs a message.
         * @memberof invicti.auth
         * @method log
         * @param {string} message The message.
         * @example
         * // Log a simple message
         * invicti.auth.log('Hello world!');
         */
        log: logVerbose,

        /**
         * Executes the supplied code in specified frame element.
         * @memberof invicti.auth
         * @method executeInFrame
         * @param {(string|HTMLElement)} frameEl The frame element id or DOM reference to execute code.
         * @param {string} code The code to execute.
         * @param {number} [delay] The number of milliseconds (thousandths of a second) that the code execution should be delayed by. Note that all delays are timed from the beginning of the script execution and does not work in sequence if you have several function calls with delay.
         * @example
         * // Clicks an element inside a frame
         * var frame = document.getElementsByTagName('IFRAME')[1];
         * invicti.auth.executeInFrame(frame, 'invicti.auth.click("LoginButton");');
         */
        executeInFrame: function (frameEl, code, delay) {
            updateTotalDelay(delay);
            frameEl.contentWindow.postMessage({ '__nsExecute': true, 'code': code, 'delay': delay }, '*');
        },

        getSessionStorage: function () {
            var values = [];

            for (var name in sessionStorage) {
                if (sessionStorage.hasOwnProperty(name)) {
                    values.push([name, sessionStorage[name]]);
                }
            }

            return values;
        },

        getLocalStorage: function () {
            var values = [];

            for (var name in localStorage) {
                if (localStorage.hasOwnProperty(name)) {
                    values.push([name, localStorage[name]]);
                }
            }

            return values;
        },

        getIndexedDbStorage: async function () {
            window.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
            var databaseLst = await new Promise(function (resolve, reject) {
                var dbRes = indexedDB.databases();

                dbRes.then(databases => {
                    resolve(databases);
                });
            });

            var databases = [];

            for (var i = 0; i < databaseLst.length; i++) {
                var openDb = await nsOpenIndexedDb(databaseLst[i].name);
                var indexedDbStorages = [];
                for (var j = 0; j < openDb.objectStoreNames.length; j++) {
                    var res = await nsGetIndexedStorageValues(openDb, openDb.objectStoreNames[j]);
                    indexedDbStorages.push([openDb.objectStoreNames[j], res]);
                }
                databases.push([databaseLst[i].name, indexedDbStorages]);
            }
            return databases;
        },

        /**
        *  Sends HTTP requests and returns response details.
        * <p> There are three usages of this function:
        * <p> 1. If called with a string parameter, sends a GET request to the given URI and returns the response (async).
        * <p> 2. If called with no parameters, returns a requestObject to be passed to the function itself (async).
        * <p> 3. If called with requestObject parameter, sends a request which is defined by requestObject.
        * <p> This function returns a response object which is explained at the latest example.
        * @memberof invicti.auth
        * @method request
        * @param {string} [uri] The target uri to send GET request.
        * @param {object} [requestObject] Object containing request details.
        * @example
        * var response = await invicti.auth.request("http://example.com");
        * @example
        * var requestObject = invicti.auth.request();
        * requestObject.uri = "http://example.com";
        * requestObject.method = "POST";
        * requestObject.parameters.add("parameterKey", "parameterValue", 1); // 0 - GET (QueryString) 1 - POST parameter
        * requestObject.headers.add("headerName", "headerValue");
        * var response = await invicti.auth.request(requestObject);
        *
        * @example
        * var response = invicti.auth.request("http://example.com");
        * response.body; // the body of the response.
        * response.headers; // collection of response headers.
        * response.responseTime; // response time.
        * response.statusCode; // HTTP status code of the response.
        * response.statusDescription; // Human readable description of the HTTP response code.
        * response.uri; // The uri that HTTP request has sent.
        */
        request: async function (parameter) {
            var parameterType = typeof parameter;

            if (parameterType === "string") {
                var result = await __requestUri(parameter);
                var response = result.response;
                try {
                    return JSON.parse(response);
                } catch (e) {
                    return response;
                }
            } else if (parameterType === "object") {
                var result = await __requestCustom(JSON.stringify(parameter));
                var response = result.response;
                try {
                    return JSON.parse(response);
                } catch (e) {
                    return response;
                }
            } else if (parameterType === "undefined") {
                return {
                    uri: "",
                    method: "GET",
                    body: "",
                    parameters: {
                        add: function (key, value, type) {
                            this[key] = { value: value, type: type };
                        },
                        remove: function (key) {
                            delete this[key];
                        }
                    },
                    headers: {
                        add: function (key, value) {
                            this[key] = value;
                        },
                        remove: function (key) {
                            delete this[key];
                        }
                    }
                }
            }

            return null;
        }

    };
})();
if (!nsOptions.DisableBotDetection) {
    executeBotDetection();
}
