/*
 * Decompiled with CFR 0.152.
 */
package com.invicti.iast.agent;

import com.invicti.iast.agent.ConfigurableDualFormatter;
import com.invicti.iast.agent.InvictiConsoleHandler;
import com.invicti.iast.agent.ServerCheckUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LoggerUtils {
    private LoggerUtils() {
    }

    protected static void addConsoleHandlerToLogger(Logger logger, String format) {
        logger.setUseParentHandlers(false);
        InvictiConsoleHandler ch = new InvictiConsoleHandler(ServerCheckUtils.isWebSphereTraditional());
        ch.setLevel(Level.FINE);
        ch.setFormatter(new ConfigurableDualFormatter(format));
        logger.addHandler(ch);
        logger.setLevel(Level.FINE);
    }

    protected static void removeOtherLoggerHandlers(Logger logger) {
        Set handlersSet = Arrays.stream(logger.getHandlers()).collect(Collectors.toSet());
        for (Handler handler : handlersSet) {
            logger.removeHandler(handler);
        }
    }
}

