/*
 * Decompiled with CFR 0.152.
 */
package com.invicti.iast.agent;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class InvictiShadedClassLoader
extends URLClassLoader {
    public static final String SHADED_CLASS_EXTENSION = ".inclass";
    private static final String CLASS_EXTENSION = ".class";
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private final Manifest manifest;
    private final URL jarUrl;
    private final ThreadLocal<Set<String>> locallyNonAvailableResources = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    public InvictiShadedClassLoader(URL jar, ClassLoader parent) throws IOException {
        super(new URL[]{jar}, parent);
        this.jarUrl = jar;
        JarURLConnection jarConnection = (JarURLConnection)this.jarUrl.openConnection();
        JarFile jarFile = jarConnection.getJarFile();
        this.manifest = jarFile.getManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            try {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(c);
                    }
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                return name.startsWith("com.invicti.iast.boot") ? this.loadBootClass(name, false) : super.loadClass(name, resolve);
            }
        }
    }

    private Class<?> loadBootClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.startsWith("com.invicti.iast.boot")) {
            throw new IllegalArgumentException("The class name is not part of the com.invicti.iast.boot package");
        }
        return Class.forName(name, resolve, null);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.getShadedClassBytes(name);
        if (classBytes != null) {
            return this.defineClass(name, classBytes);
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> defineClass(String name, byte[] classBytes) {
        block5: {
            String packageName = this.getPackageName(name);
            if (packageName != null && !this.isPackageDefined(packageName)) {
                try {
                    if (this.manifest != null) {
                        this.definePackage(packageName, this.manifest, this.jarUrl);
                    } else {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (this.isPackageDefined(packageName)) break block5;
                    throw e;
                }
            }
        }
        return this.defineClass(name, classBytes, 0, classBytes.length, PROTECTION_DOMAIN);
    }

    private boolean isPackageDefined(String packageName) {
        return Arrays.stream(this.getPackages()).anyMatch(pck -> pck.getName().equalsIgnoreCase(packageName));
    }

    public String getPackageName(String className) {
        int i = className.lastIndexOf(46);
        if (i != -1) {
            return className.substring(0, i);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getShadedClassBytes(String name) throws ClassNotFoundException {
        try (InputStream is = this.getResourceAsStreamInternal(name.replace('.', '/') + SHADED_CLASS_EXTENSION);){
            int n;
            if (is == null) return null;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((n = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, n);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private InputStream getResourceAsStreamInternal(String name) {
        return super.getResourceAsStream(name);
    }

    @Override
    public URL findResource(String name) {
        if (this.locallyNonAvailableResources.get().contains(name)) {
            return null;
        }
        return this.findResourceInternal(this.getShadedResourceName(name));
    }

    private URL findResourceInternal(String name) {
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.locallyNonAvailableResources.get().contains(name)) {
            return Collections.emptyEnumeration();
        }
        Enumeration<URL> result = super.findResources(this.getShadedResourceName(name));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        URL shadedResource = this.findResource(name);
        if (shadedResource != null) {
            return shadedResource;
        }
        Set<String> locallyNonAvailableResources = this.locallyNonAvailableResources.get();
        try {
            locallyNonAvailableResources.add(name);
            URL uRL = super.getResource(name);
            return uRL;
        }
        finally {
            locallyNonAvailableResources.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> shadedResources = this.findResources(name);
        if (shadedResources.hasMoreElements()) {
            return shadedResources;
        }
        Set<String> locallyNonAvailableResources = this.locallyNonAvailableResources.get();
        try {
            locallyNonAvailableResources.add(name);
            Enumeration<URL> enumeration = super.getResources(name);
            return enumeration;
        }
        finally {
            locallyNonAvailableResources.remove(name);
        }
    }

    private String getShadedResourceName(String name) {
        return name.endsWith(CLASS_EXTENSION) ? name.substring(0, name.length() - CLASS_EXTENSION.length()) + SHADED_CLASS_EXTENSION : name;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        PROTECTION_DOMAIN = InvictiShadedClassLoader.class.getProtectionDomain();
    }
}

