/*
 * Decompiled with CFR 0.152.
 */
package com.invicti.iast.agent;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class ConfigurableDualFormatter
extends SimpleFormatter {
    private String format = "";
    private Formatter primary = null;

    public ConfigurableDualFormatter(String format) {
        this.format = format;
    }

    public ConfigurableDualFormatter(String format, Formatter formatter) {
        this.format = format;
        this.primary = formatter;
    }

    @Override
    public synchronized String format(LogRecord record) {
        if (this.primary == null || record.getSourceClassName().startsWith("com.invicti") || record.getLoggerName().toLowerCase().contains("invicti")) {
            String source;
            Date dat = new Date();
            dat.setTime(record.getMillis());
            if (record.getSourceClassName() != null) {
                source = record.getSourceClassName();
                if (record.getSourceMethodName() != null) {
                    source = source + " " + record.getSourceMethodName();
                }
            } else {
                source = record.getLoggerName();
            }
            String message = this.formatMessage(record);
            String throwable = "";
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return String.format(this.format, dat, source, record.getLoggerName(), record.getLevel().getName(), message, throwable);
        }
        return this.primary.format(record);
    }
}

