/*
 * Decompiled with CFR 0.152.
 */
package com.invicti.iast.agent;

import com.invicti.iast.agent.ConfigurableDualFormatter;
import com.invicti.iast.agent.InvictiShadedClassLoader;
import com.invicti.iast.agent.LoggerUtils;
import com.invicti.iast.agent.ServerCheckUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Agent {
    private static final Logger LOGGER;
    public static final String INVICTI_PROP_DEBUG = "acusensor.debug.log";
    public static final String INVICTI_PROP_DEBUG_ON = "ON";
    private static final String INVICTI_PROP_DEBUG_OFF = "OFF";
    private static final String format;
    private static List<URL> tempAdviceJars;
    private static File tempCoreJarFile;

    private static boolean initLogging() {
        String debugSet = System.getProperty(INVICTI_PROP_DEBUG, INVICTI_PROP_DEBUG_OFF);
        if (INVICTI_PROP_DEBUG_ON.equalsIgnoreCase(debugSet)) {
            Agent.initGeneralLogging();
            LOGGER.setLevel(Level.FINE);
            return true;
        }
        LOGGER.setLevel(Level.INFO);
        return false;
    }

    private static void initGeneralLogging() {
        if (!LOGGER.getUseParentHandlers() && LOGGER.getHandlers().length <= 0) {
            LoggerUtils.addConsoleHandlerToLogger(LOGGER, format);
        }
        if (ServerCheckUtils.isWebSphere()) {
            LoggerUtils.addConsoleHandlerToLogger(LOGGER, format);
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        System.setProperty("logging.level.com.invicti", "TRACE");
        System.setProperty("logging.level.invicti.debug", "TRACE");
        ClassLoader agentClassLoader = Agent.class.getClassLoader();
        try {
            Agent.initLogging();
            Agent.logMessage(Level.INFO, "Invicti Java Sensor Starting ...", new Object[0]);
            if (ServerCheckUtils.isWebSphereTraditional()) {
                Agent.logMessage(Level.INFO, "The Java Sensor is being loaded in a Web Sphere Traditional environment...", new Object[0]);
            }
            if (System.getProperty("jboss.home.dir") != null) {
                String jbossSystemPackages = System.getProperty("jboss.modules.system.pkgs");
                if (jbossSystemPackages == null || jbossSystemPackages.trim().length() == 0) {
                    System.setProperty("jboss.modules.system.pkgs", "com.invicti.iast.boot");
                } else {
                    System.setProperty("jboss.modules.system.pkgs", jbossSystemPackages + ",com.invicti.iast.boot");
                }
            }
            InputStream bootstrapJarStream = agentClassLoader.getResourceAsStream("lib/invicti-bootstrap.jar");
            File tempJarFile = Agent.getTempFileForInputStream(null, bootstrapJarStream);
            inst.appendToBootstrapClassLoaderSearch(new JarFile(tempJarFile));
            InputStream coreJarStream = agentClassLoader.getResourceAsStream("lib/invicti-agent-core.jar");
            tempCoreJarFile = Agent.getTempFileForInputStream(null, coreJarStream);
            URL agentCoreJar = null;
            try {
                agentCoreJar = Agent.convertFileURLtoJarURL(tempCoreJarFile.toURI().toURL());
                Agent.logMessage(Level.FINE, "Invicti Sensor Core located at %s", agentCoreJar.toString());
            }
            catch (MalformedURLException ex) {
                Agent.logMessage(Level.SEVERE, "An error occured while identifying location of Sensor Core", ex, new Object[0]);
            }
            try {
                InputStream adviceJarStream = agentClassLoader.getResourceAsStream("lib/invicti-advice.jar");
                File adviceJarFile = Agent.getTempFileForInputStream("core-advice", adviceJarStream);
                tempAdviceJars.add(Agent.convertFileURLtoJarURL(adviceJarFile.toURI().toURL()));
                InputStream adviceS5JarStream = agentClassLoader.getResourceAsStream("lib/invicti-advice-spring5.jar");
                File adviceS5JarFile = Agent.getTempFileForInputStream(null, adviceS5JarStream);
                tempAdviceJars.add(Agent.convertFileURLtoJarURL(adviceS5JarFile.toURI().toURL()));
                InputStream adviceS6JarStream = agentClassLoader.getResourceAsStream("lib/invicti-advice-spring6.jar");
                File adviceS6JarFile = Agent.getTempFileForInputStream(null, adviceS6JarStream);
                tempAdviceJars.add(Agent.convertFileURLtoJarURL(adviceS6JarFile.toURI().toURL()));
            }
            catch (MalformedURLException ex) {
                Agent.logMessage(Level.SEVERE, "An error occured while preparing advice jars", ex, new Object[0]);
            }
            InputStream propsInputStream = agentClassLoader.getResourceAsStream("acu.properties");
            InvictiShadedClassLoader agentCoreClassLoader = new InvictiShadedClassLoader(agentCoreJar, agentClassLoader);
            Class.forName("com.invicti.iast.agent.AgentLoader", true, agentCoreClassLoader).getMethod("loadAgent", String.class, Instrumentation.class, List.class, InputStream.class).invoke(null, agentArgs, inst, tempAdviceJars, propsInputStream);
        }
        catch (Exception eg) {
            Agent.logMessage(Level.SEVERE, "An error occured while loading Sensor Core with error %s", eg.getMessage());
        }
    }

    static void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) != -1) {
            target.write(buf, 0, length);
        }
    }

    private static URL convertFileURLtoJarURL(URL fileURL) throws MalformedURLException {
        String JAR_PROTOCOL = "jar:file:";
        String JAR_URL_POSTFIX = "!/";
        String filePath = fileURL.toExternalForm();
        if (filePath.startsWith("file:")) {
            filePath = filePath.substring(5);
        }
        String protocolPostFix = filePath.startsWith("/") ? "" : "/";
        String jarURL = "jar:file:" + protocolPostFix + filePath.replace('\\', '/') + "!/";
        URL parsedURL = new URL(jarURL);
        return parsedURL;
    }

    private static File getTempFileForInputStream(String prefix, InputStream is) throws IOException {
        File tempJarFile = Files.createTempFile(prefix, ".jar", new FileAttribute[0]).toFile();
        Agent.logMessage(Level.FINE, "Creating temp jar: %s", tempJarFile.getPath());
        FileOutputStream fos = new FileOutputStream(tempJarFile);
        Agent.copy(is, fos);
        fos.flush();
        fos.close();
        tempJarFile.deleteOnExit();
        return tempJarFile;
    }

    private static void logMessage(Level level, String message, Object ... args) {
        Agent.logMessage(level, message, null, args);
    }

    private static void logMessage(Level level, String message, Throwable cause, Object ... args) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        LOGGER.logp(level, String.format(message, args), elements[3].getClassName(), elements[3].getMethodName());
    }

    static {
        tempAdviceJars = new ArrayList<URL>();
        format = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS [invicti.debug] %4$s %2$s %5$s%6$s%n";
        Logger rootLogger = Logger.getLogger("");
        Set rootHandlersSet = Arrays.stream(rootLogger.getHandlers()).collect(Collectors.toSet());
        for (Handler handler : rootHandlersSet) {
            handler.setLevel(Level.FINE);
            Formatter currentFormatter = handler.getFormatter();
            handler.setFormatter(new ConfigurableDualFormatter(format, currentFormatter));
        }
        LOGGER = Logger.getLogger("invicti.debug");
        LOGGER.setUseParentHandlers(true);
    }
}

